% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{vc_heatmap}
\alias{vc_heatmap}
\title{Plot a variant-cell heatmap for cell clonal assignment}
\usage{
vc_heatmap(mat, prob, Config, show_legend = FALSE)
}
\arguments{
\item{mat}{A matrix for heatmap: N variants x M cells. row and column will be
sorted automatically.}

\item{prob}{A matrix of probability of clonal assignment: M cells x K clones}

\item{Config}{A binary matrix of clonal Configuration: N variants x K clones}

\item{show_legend}{A bool value: if TRUE, show the legend}
}
\value{
a pheatmap object

a ggplot object
}
\description{
Plot a variant-cell heatmap for cell clonal assignment
}
\examples{
data(example_donor)
assignments <- clone_id(A_clone, D_clone, Config = tree$Z)
fig <- vc_heatmap(assignments$prob_variant, assignments$prob, tree$Z)
}
\references{
This function makes use of the \code{\link{pheatmap}} packages
}
