% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{prob_heatmap}
\alias{prob_heatmap}
\title{Plot a heatmap for probability of clone assignment}
\usage{
prob_heatmap(prob_mat, threshold = 0.5, mode = "best", cell_idx = NULL)
}
\arguments{
\item{prob_mat}{A matrix (M x K), the probability of cell j to clone k}

\item{threshold}{A float value, the threshold for assignable cells}

\item{mode}{A string, the method for defining scores for filtering cells:
best and delta. best: highest probability of a cell to K clones, delta: the
difference between the best and second.}

\item{cell_idx}{A vector the indices of the input cells. If NULL, order by
the probability of each clone}
}
\value{
a ggplot object
}
\description{
Plot a heatmap for probability of clone assignment
}
\examples{
data(example_donor)
assignments <- clone_id(A_clone, D_clone, Config = tree$Z, inference = "EM")
fig <- prob_heatmap(assignments$prob)
}
