% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_utils.R
\name{get_tree}
\alias{get_tree}
\title{Get a clonal tree from a configuration matrix}
\usage{
get_tree(Config, P = NULL, strictness = "lax")
}
\arguments{
\item{Config}{variant x clone matrix of binary values. The clone-variant
configuration, which encodes the phylogenetic tree structure. This is the
output Z of Canopy}

\item{P}{a one-column numeric matrix encoding the (observed or estimated)
prevalence (or frequency) of each clone}

\item{strictness}{character(1), a character string defining the strictness of
the function if there are all-zero rows in the Config matrix. If \code{"lax"}
then the function silently drops all-zero rows and proceeds. If \code{"warn"}
then the function warns of dropping all-zero rows and proceeds. If
\code{"error"} then the function throws an error is all-zero rows are
detected.}
}
\value{
An object of class "phylo" describing the tree structure. The output object
also contains an element "sna" defining the clustering of variants onto the
branches of the tree, and if \code{P} is non-null it also contains VAF
(variant allele frequency), CCF (cell clone fraction) and clone prevalence
values (computed from the supplied \code{P} argument).
}
\description{
Get a clonal tree from a configuration matrix
}
\details{
Output tree may be nonsensical if the input \code{Config} matrix does not
define a coherent tree structure.
}
\examples{
Configk3 <- matrix(c(
    rep(0, 15), rep(1, 8), rep(0, 7), rep(1, 5), rep(0, 3),
    rep(1, 7)
), ncol = 3)
tree_k3 <- get_tree(Config = Configk3, P = matrix(rep(1 / 3, 3), ncol = 1))
plot_tree(tree_k3)
}
\author{
Davis McCarthy
}
