% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{get_snp_matrices}
\alias{get_snp_matrices}
\title{Get SNP data matrices from VCF object(s)}
\usage{
get_snp_matrices(vcf_cell, vcf_donor = NULL, verbose = TRUE, donors = NULL)
}
\arguments{
\item{vcf_cell}{a \code{\link[VariantAnnotation]{CollapsedVCF}} object
containing variant data for cells}

\item{vcf_donor}{an optional \code{\link[VariantAnnotation]{CollapsedVCF}}
object containing genotype data for donors}

\item{verbose}{logical(1), should the function output verbose information as
it runs?}

\item{donors}{optional character vector providing a set of donors to use, by
subsetting the donors present in the \code{donor_vcf_file}; if \code{NULL}
(default) then all donors present in VCF will be used.}
}
\value{
a list containing
\code{A}, a matrix of integers. Number of alteration reads in SNP i cell j.
\code{D}, a matrix of integers. Number of reads depth in SNP i cell j.
\code{R}, a matrix of integers. Number of reference reads in SNP i cell j.
\code{GT_cells}, a matrix of integers for genotypes. The cell-SNP
configuration.
\code{GT_donors}, a matrix of integers for genotypes. The donor-SNP
configuration.
}
\description{
Get SNP data matrices from VCF object(s)
}
\examples{
vcf_cell <- read_vcf(system.file("extdata", "cells.donorid.vcf.gz",
                     package = "cardelino"))
vcf_donor <-  read_vcf(system.file("extdata", "donors.donorid.vcf.gz",
                       package = "cardelino"))
snp_data <- get_snp_matrices(vcf_cell, vcf_donor)

}
