% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{ReadBrenda}
\alias{ReadBrenda}
\title{Read BRENDA text file into matrix.}
\usage{
ReadBrenda(filepath, clean = TRUE)
}
\arguments{
\item{filepath}{A string indicating the path to the text file.}

\item{clean}{Boolean; if TRUE, run \code{\link[=CleanECNumber]{CleanECNumber()}} after reading the file.}
}
\value{
A matrix containing information about the EC entries.
}
\description{
For each EC entry, split the annotations into three columns:
\itemize{
\item ID: EC number, e.g. 1.1.1.1
\item field: the content of the information, e.g. protein, localization
\item description: everything else
}
}
\examples{
brenda_txt <- system.file("extdata", "brenda_download_test.txt",
                          package = "brendaDb")
df <- ReadBrenda(brenda_txt)

}
