% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-nomenclature.R
\name{ParseProtein}
\alias{ParseProtein}
\title{Parse a "PROTEIN" entry.}
\usage{
ParseProtein(description)
}
\arguments{
\item{description}{The description string in a "PROTEIN" entry.}
}
\value{
A \code{tibble} with five columns: proteinID, description, uniprot,
commentary and reference. The description column is the source organism.
}
\description{
Expand the string into a \code{tibble}.
}
\examples{
x <- paste0(
"PR\t#1# Cavia porcellus  (#1# SULT1A2 <1,2,6,7>) <1,2,6,7>\n",
"PR\t#2# Mus musculus <11,18,19>\n")
brendaDb:::ParseProtein(x)

}
\keyword{internal}
