% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifySampleNames.R
\name{simplifySampleNames}
\alias{simplifySampleNames}
\title{Simplify bsseq sample names}
\usage{
simplifySampleNames(x)
}
\arguments{
\item{x}{A SummarizedExperiment-derived object, or a character vector}
}
\value{
The input object, but with simplified sample names
}
\description{
Tries using the longest common subsequence to figure out what can be
dropped. Usually used for VCF columns.
}
\examples{

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  bisc <- readBiscuit(BEDfile = orig_bed, VCFfile = orig_vcf,
                      merged = FALSE)

  bisc <- simplifySampleNames(bisc)

}
