% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBiscuit.R
\name{readBiscuit}
\alias{readBiscuit}
\alias{loadBiscuit}
\title{Read biscuit output into bsseq object}
\usage{
readBiscuit(
  BEDfile,
  VCFfile,
  merged,
  sampleNames = NULL,
  simplify = FALSE,
  genome = "hg19",
  how = c("data.table", "readr"),
  hdf5 = FALSE,
  hdf5dir = NULL,
  sparse = FALSE,
  chunkSize = 1e+06,
  chr = NULL,
  which = NULL,
  verbose = FALSE
)

loadBiscuit(
  BEDfile,
  VCFfile,
  merged,
  sampleNames = NULL,
  simplify = FALSE,
  genome = "hg19",
  how = c("data.table", "readr"),
  hdf5 = FALSE,
  hdf5dir = NULL,
  sparse = FALSE,
  chunkSize = 1e+06,
  chr = NULL,
  which = NULL,
  verbose = FALSE
)
}
\arguments{
\item{BEDfile}{A BED-like file - must be compressed and tabix'ed}

\item{VCFfile}{A VCF file - must be compressed and tabix'ed. Only the
header information is needed.}

\item{merged}{Is this merged CpG data?}

\item{sampleNames}{Names of samples - NULL: create names, vector: assign
names, data.frame: make pData (DEFAULT: NULL)}

\item{simplify}{Simplify sample names by dropping .foo.bar.hg19? (or
similar) (DEFAULT: FALSE)}

\item{genome}{Genome assembly the runs were aligned against
(DEFAULT: "hg19")}

\item{how}{How to load data - either data.table or readr
(DEFAULT: "data.table")}

\item{hdf5}{Make the object HDF5-backed - CURRENTLY NOT AVAILABLE
(DEFAULT: FALSE)}

\item{hdf5dir}{Directory to store HDF5 files if 'hdf5' = TRUE
(DEFAULT: NULL)}

\item{sparse}{Use sparse Matrix objects for the data? (DEFAULT: FALSE)}

\item{chunkSize}{Number of rows before readr reading becomes chunked
(DEFAULT: 1e6)}

\item{chr}{Load a specific chromosome? (DEFAULT: NULL)}

\item{which}{A GRanges of regions to load - NULL loads them all
(DEFAULT: NULL)}

\item{verbose}{Print extra statements? (DEFAULT: FALSE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{        A bsseq::BSseq object
}\if{html}{\out{</div>}}
}
\description{
Takes BED-like format with 2 or 3 columns per sample. Unmerged CpG files
have 2 columns (beta values and coverage), whereas merged CpG files have
3 columns (beta values, coverage, and context).
}
\details{
NOTE: Assumes alignment against hg19 (use genome argument to override).
NOTE: Requires header from VCF file to detect sample names
}
\section{Functions}{
\itemize{
\item \code{loadBiscuit()}: Alias for readBiscuit

}}
\examples{

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  bisc <- readBiscuit(BEDfile = orig_bed, VCFfile = orig_vcf,
                      merged = FALSE)

}
\seealso{
bsseq

checkBiscuitBED
}
