% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremality.R
\name{extremality}
\alias{extremality}
\title{Compute fraction of a Bernoulli variance}
\usage{
extremality(x, raw = FALSE)
}
\arguments{
\item{x}{A rectangular object with proportions in it}

\item{raw}{Skip the correction pass? (DEFAULT: FALSE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{The extremality of each row (if more than one) of the object
}\if{html}{\out{</div>}}
}
\description{
Works efficiently on matrices and DelayedMatrix objects. Note that it is
possible for "raw" extremality to be greater than 1, so this function does
a second pass to correct for this.
}
\examples{

  x <- rnorm(100, mean=0.5, sd=0.15)
  x <- matrix(x, nrow=50, ncol=2)

  ext <- extremality(x, raw=TRUE)

}
