% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condenseSampleNames.R
\name{condenseSampleNames}
\alias{condenseSampleNames}
\title{Simplify sample names for a bsseq object}
\usage{
condenseSampleNames(tbx, stride, trailing = "\\\\.$")
}
\arguments{
\item{tbx}{A TabixFile instance to parse}

\item{stride}{How many columns per sample}

\item{trailing}{Trailing character to trim (DEFAULT: "\\.$")}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     A character vector of sample names (longest common
               substrings)
}\if{html}{\out{</div>}}
}
\description{
Utility function for extracting sample names from tabix'ed sample columns,
assuming a VCF-naming scheme (such as Sample_1.foo, Sample_1.bar or
Sample1_foo, Sample1_bar).
}
\examples{

  library(Rsamtools)
  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  if (length(headerTabix(orig_bed)$header) > 0) {
    condenseSampleNames(orig_bed, 2)
  }

}
