% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byChromArm.R
\name{byChromArm}
\alias{byChromArm}
\title{A simple parallization step}
\usage{
byChromArm(x, arms = NULL)
}
\arguments{
\item{x}{Any object with a GRanges in it: bsseq, SummarizedExperiment...}

\item{arms}{Another GRanges, but specifying chromosome arms (DEFAULT: NULL)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ A list, List, or *list, with pieces of x by chromosome arm
}\if{html}{\out{</div>}}
}
\description{
This function splits an object by chromosome arm, which tends to make
parallelization much easier, as cross-arm dependencies are unusual.
Therefore, the larger chromosomes can be split across processes or machines
without worrying much about data starvation for processes on smaller
chromosomes.
}
\examples{

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  bisc <- readBiscuit(BEDfile = orig_bed, VCFfile = orig_vcf,
                      merged = FALSE)

  reg <- GRanges(seqnames = rep("chr11",5),
                 strand = rep("*",5),
                 ranges = IRanges(start = c(0,2.8e6,1.17e7,1.38e7,1.69e7),
                                  end= c(2.8e6,1.17e7,1.38e7,1.69e7,2.2e7))
                 )
  names(reg) <- as.character(reg)

  arms <- byChromArm(bisc, arms = reg)

}
