% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_bioc_description.R
\name{use_bioc_description}
\alias{use_bioc_description}
\title{Create a biocthis-style DESCRIPTION template}
\usage{
use_bioc_description(biocViews = "Software", report_bioc = FALSE)
}
\arguments{
\item{biocViews}{A \code{character()} with the Bioconductor biocViews terms you
want to use for your package. See
\url{https://bioconductor.org/packages/release/BiocViews.html} for details. Note
that the terms you choose have to be part of one of the main four trees:
software, annotation, experiment or workflow.}

\item{report_bioc}{A \code{logical(1)} indicating whether to set the \code{BugReports}
to the Bioconductor Support website \url{https://support.bioconductor.org/}
or to the GitHub package issues page. As noted on December 18 2024 at
\url{https://github.com/Bioconductor/Contributions/issues/3503#issuecomment-2551233199},
Bioconductor reviewers prefer to use the GitHub issues page for \code{BugReports}.
This is also documented at
\url{https://contributions.bioconductor.org/description.html#description-bugreport}.}
}
\value{
This function adds and/or replaces the \code{DESCRIPTION} file in your
R package.
}
\description{
This function is very similar to \code{usethis::use_description()} except
that it uses a template from \code{biocthis}. This template includes some of the
information expected in the DESCRIPTION file of a Bioconductor package. You
can compare the output of this function to the one from
\code{usethis::use_description()} to select the parts you want from each.
}
\details{
For details about the DESCRIPTION file guidelines for Bioconductor
packages check
\url{http://bioconductor.org/developers/package-guidelines/#description}.
}
\examples{
\dontrun{
## Run this function in your package
use_bioc_description()
}

## Create an example package for illustrative purposes.
## Note: you do not need to run this for your own package!
pkgdir <- biocthis_example_pkg(use_git = TRUE)

## Create a template DESCRIPTION file that is Bioconductor-friendly
biocthis::use_bioc_description()
}
