% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_bioc_coc.R
\name{use_bioc_coc}
\alias{use_bioc_coc}
\title{Create a Bioconductor-styled code of conduct}
\usage{
use_bioc_coc(path = ".github")
}
\arguments{
\item{path}{A \code{character(1)} specifying the location where the
\code{CODE_OF_CONDUCT.md} will be saved at in relation to the root of your
R package.}
}
\value{
This function adds and/or replaces the \code{.github/CODE_OF_CONDUCT.md}
file in your R package.
}
\description{
This function is very similar to \code{usethis::use_tidy_cov()} except
that it uses a template from \code{biocthis}. This template links to the
Bioconductor Code of Conduct available at
\url{http://bioconductor.org/about/code-of-conduct/}. The function adds by
default the file \code{.github/CODE_OF_CONDUCT.md} with a brief overview of
the Bioconductor Code of Conduct and links to the latest version.
}
\examples{
\dontrun{
## Run this function in your package
use_bioc_coc()
}

## Create an example package for illustrative purposes.
## Note: you do not need to run this for your own package!
pkgdir <- biocthis_example_pkg()

## Create a Bioconductor-styled CODE_OF_CONDUCT.md
biocthis::use_bioc_coc()
}
