% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longtests_rcolet.R
\name{roclet_output.roclet_longtests}
\alias{roclet_output.roclet_longtests}
\title{Process blocks for 'longtests' roclet}
\usage{
\method{roclet_output}{roclet_longtests}(x, results, base_path, ...)
}
\arguments{
\item{x}{An object of class 'roclet_longtests'.
package.}

\item{results}{A list with a single element 'longtests', which contains the}

\item{base_path}{A character string representing the base path of the}

\item{...}{Additional arguments passed to the function.}
}
\value{
A list with a single element 'longtests', which contains the
processed test files.
}
\description{
This function processes a list of blocks for the 'longtests' roclet. It calls
the 'internal_longtests_roclet_process' function with the specified blocks
and additional arguments. The code in the tests is indented, a 'test_that'
boilerplate is added to the tests, and a 'context' line is not added to the
header.
}
\examples{
# Set up a temporary directory
base_path <- tempdir()
longtests_path <- file.path(base_path, "longtests", "testthat")
unlink(longtests_path, recursive = TRUE, force = TRUE)
dir.create(longtests_path, recursive = TRUE, showWarnings = FALSE)

# Create dummy inputs
obj <- longtests_roclet()
results <- list(longtests = list())

# Run the roclet_output function
result <- roxygen2::roclet_output(obj, results, base_path)
}
