% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotationFuncs.R
\name{getOrthologs}
\alias{getOrthologs}
\title{Performs quicker lookup for orthologs in homologe data packages}
\usage{
getOrthologs(
  values,
  mapping,
  genus,
  threshold = 1,
  pre.from = NULL,
  pre.to = NULL,
  post.from = NULL,
  post.to = NULL,
  ...
)
}
\arguments{
\item{values}{Vector, coerced to character vector, of values needed mapping by homology.}

\item{mapping}{Homology mapping object, such as \code{hom.Hs.inpBOSTA} or \code{revmap(hom.Hs.inpBOSTA)}.}

\item{genus}{Character vector. 5 character INPARANOID style genus name of the mapping object, e.g. 'BOSTA' for both \code{hom.Hs.inpBOSTA} and \code{revmap(hom.Hs.inpBOSTA)}.}

\item{threshold}{Numeric value between 0 and 1. Only clustered homologues with a parwise score above the threshold is included.
The native implementation has this set to 1.}

\item{pre.from}{Mapping object if \code{values} needs translation before mapping.
E.g. \code{values} are entrez and \code{hom.Hs.inpBOSTA} requires ENSEMBLPROT, \code{hom.Hs.inpAPIME} requires Refseq (?).
Arguments \code{from} and \code{to} are just like in \code{\link{translate}}.}

\item{pre.to}{Second part of translation before mapping.}

\item{post.from}{Translate the result from homology mapping to a desired id; just like in \code{\link{translate}}.}

\item{post.to}{Second part of translation after mapping.}

\item{...}{Additional arguments sent to \code{\link{translate}}.}
}
\value{
List. Names of list corresponds to \code{values}, except those that could not be mapped nor translated.
              Entries are character vectors.
}
\description{
Using the INPARANOID data packages such as \code{hom.Hs.inp.db} is very, very slow and can take up to 11 min (on this particular developers workstation).
This function introduces a new method that can do it in just 20 seconds (on the developers workstation).
In addition, it includes options for translating between different identifers both before and after the mapping.
}
\examples{
tmp <-1

}
\references{
\code{?hom.Hs.inp.db} - \url{https://inparanoidb.sbc.su.se/}

 Berglund, A.C., Sjolund, E., Ostlund, G., Sonnhammer, E.L.L. (2008)
 InParanoid 6: eukaryotic ortholog clusters with inparalogs
 \emph{Nucleic Acids Res.} \bold{36}:D263--266

 O'Brien, K.P., Maido, R., Sonnhammer, E.L.L (2005)
 Inparanoid: A Comprehensive Database of Eukaryotic Orthologs
 \emph{NAR} \bold{33}:D476--D480

 Remm, M., Storm, C.E.V, Sonnhammer, E.L.L (2001)
 Automatic clustering of orthologs and in-paralogs from pairwise species comparisons
 \emph{J. Mol. Biol.} \bold{314}:1041--1052
}
\seealso{
\code{\link{translate}}, \code{\link{.getTableName}}, \code{\link{mapLists}}
}
\author{
Stefan McKinnon Edwards \email{stefan.hoj-edwards@agrsci.dk}
}
