% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enrich.R
\name{checkDimensions}
\alias{checkDimensions}
\title{Check wich Cases and genetic profiles are available for selected study}
\usage{
checkDimensions(StudyID)
}
\arguments{
\item{StudyID}{Study reference using cBioPortal index}
}
\value{
A data frame with two column (Cases, Genetic profiles). Every row has a dimension (CNA, mRNA...).
The data frame is filled with yes/no response.
}
\description{
Check wich Cases and genetic profiles are available for selected study
}
\examples{
cgds <- cBioPortal(
hostname = "www.cbioportal.org",
protocol = "https",
api = "/api/v2/api-docs"
)
\dontrun{
getDataByGenes( api =  cgds,
studyId = "gbm_tcga_pub",
genes = c("NF1", "TP53", "ABL1"),
by = "hugoGeneSymbol",
molecularProfileIds = "gbm_tcga_pub_mrna"
)
}
}
