% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_Maaslin3.R
\name{set_maaslin3}
\alias{set_maaslin3}
\title{set_maaslin3}
\usage{
set_maaslin3(
  assay_name = "counts",
  normalization = c("TSS", "CLR", "NONE"),
  transform = c("LOG", "PLOG", "NONE"),
  median_comparison_abundance = c(TRUE, FALSE),
  small_random_effects = c(TRUE, FALSE),
  stat_type = c("abundance", "prevalence"),
  pvalue_type = c("abundance", "prevalence", "joint"),
  correction = "BH",
  formula = NULL,
  contrast = NULL,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{normalization}{The normalization to apply to the features before
    transformation and analysis. The option \code{TSS} (total sum scaling)
    is
    recommended, but \code{CLR} (centered log ratio) and \code{NONE} can
    also
    be used.}

\item{transform}{The transformation to apply to the features after
    normalization and before analysis. The option \code{LOG} (base 2) is
    recommended, but \code{PLOG} (pseudo-log) and \code{NONE} can also be
    used.}

\item{median_comparison_abundance}{Test abundance coefficients against a
    null value corresponding to the median coefficient for a metadata
    variable across the features. This is recommended for relative abundance
    data but should not be used for absolute abundance data.}

\item{small_random_effects}{Automatically replace random effects with 
    fixed effects in the logistic prevalence model to handle low numbers
    of observations per group.}

\item{stat_type}{Whether to return statistics based on abundance 
("abundance") or prevalence ("prevalence") models.}

\item{pvalue_type}{Whether to return p-values based on abundance 
("abundance") models, prevalence ("prevalence") models, or joint 
("joint") p-values. Choose "abundance" or "joint" when \code{stat_type} is
set to "abundance", choose "prevalence" when \code{stat_type} is set to
"prevalence".}

\item{correction}{The correction to obtain FDR-corrected q-values from
    raw
    p-values. Any valid options for \code{p.adjust} can be used.}

\item{formula}{A formula in \code{lme4} format. Random effects,
    interactions, and functions of the metadata can be included (note that
    these functions will be applied after standardization if
    \code{standardize=TRUE}). Group, ordered, and strata variables can be
    specified as: \code{group(grouping_variable)},
    \code{ordered(ordered_variable)} and \code{strata(strata_variable)}. The
    other variable options below will not be considered if a formula is
    set.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_maaslin3}
method.
}
\description{
Set the parameters for maaslin3 differential abundance detection method.
}
\details{
Some maaslin3 parameters are not available for customization in this 
implementation. For this reason they assume default values or are internally
assigned. The latter case is represented by:
\itemize{
\item \code{warn_prevalence} which is internally set to \code{TRUE} when 
\code{normalization = "TSS"} and \code{transform = "LOG"};
\item \code{subtract_median} which is internally set to the same 
\code{median_comparison_abundance} value;
\item \code{zero_threshold} which is automatically set to -1 when 
\code{transform = "PLOG"};
\item \code{evaluate_only} is automatically set to \code{"abundance"} when
\code{transform = "PLOG"}.
}

MaAsLin 3 produces both abundance and prevalence associations with 
individual p and adjusted p-values (specific to abundance or prevalence) as 
well as joint p and adjusted p-values for testing whether a metadatum is 
associated with either the abundance or prevalence. To avoid issues with 
having twice as many associations as other tools (from both abundance and 
prevalence), \code{stat_type} can be set to report the desired abundance or 
prevalence associations. When the abundance and prevalence associations are 
expected to go in the same direction, \code{pvalue_type = "joint"} allows to
return p-values and adjusted p-values taken from the joint p-values and 
adjusted p-values. 
Please refer to maaslin3's guide to choose proper parameter combinations.
}
\examples{
# Set some basic combinations of parameters for maaslin3
base_maaslin3 <- set_maaslin3(normalization = "TSS", transform = "LOG",
    median_comparison_abundance = TRUE, 
    small_random_effects = FALSE, stat_type = "abundance",
    pvalue_type = "abundance", formula = ~ group,
    contrast = c("group", "B", "A"))
many_maaslin3 <- set_maaslin3(normalization = c("TSS", "CLR"),
    transform = c("LOG", "NONE"),
    median_comparison_abundance = c(TRUE, FALSE),
    small_random_effects = FALSE,
    stat_type = "abundance", pvalue_type = c("abundance", "joint"),
    formula = ~ group, contrast = c("group", "B", "A"))
}
\seealso{
\code{\link{DA_maaslin3}}
}
