% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_ANCOM.R
\name{set_ANCOM}
\alias{set_ANCOM}
\title{set_ANCOM}
\usage{
set_ANCOM(
  assay_name = "counts",
  pseudo_count = FALSE,
  fix_formula = NULL,
  adj_formula = NULL,
  rand_formula = NULL,
  lme_control = lme4::lmerControl(),
  contrast = NULL,
  alpha = 0.05,
  p_adj_method = "BH",
  struc_zero = FALSE,
  BC = TRUE,
  n_cl = 1,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{fix_formula}{Used when \code{BC = TRUE} (ANCOM-BC2). The character 
string expresses how the microbial absolute abundances for each taxon depend 
on the fixed effects in metadata.}

\item{adj_formula}{Used when \code{BC = FALSE} (ANCOM). The character string 
represents the formula for covariate adjustment. Default is NULL.}

\item{rand_formula}{Optionally used when \code{BC = TRUE} or 
\code{BC = FALSE}. The character string expresses how the microbial absolute 
abundances for each taxon depend on the random effects in metadata. 
ANCOMB and ANCOM-BC2 follows the \code{lmerTest} package in formulating the 
random effects. See \code{?lmerTest::lmer} for more details. Default is 
\code{rand_formula = NULL}.}

\item{lme_control}{a list of control parameters for mixed model fitting.
See \code{?lme4::lmerControl} for details.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{alpha}{numeric. Level of significance. Default is 0.05.}

\item{p_adj_method}{character. method to adjust p-values. Default is "holm".
Options include "holm", "hochberg", "hommel", "bonferroni", "BH", "BY",
"fdr", "none". See \code{?stats::p.adjust} for more details.}

\item{struc_zero}{logical. Whether to detect structural zeros based on
\code{group}. Default is FALSE. See \code{Details} for
a more comprehensive discussion on structural zeros.}

\item{BC}{boolean for ANCOM method to use. If TRUE the bias correction 
(ANCOM-BC2) is computed (default \code{BC = TRUE}). When \code{BC = FALSE} 
computational time may increase and p-values are not computed.}

\item{n_cl}{numeric. The number of nodes to be forked. For details, see
\code{?parallel::makeCluster}. Default is 1 (no parallel computing).}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_ANCOM}
method.
}
\description{
Set the parameters for ANCOM differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for ANCOM with bias correction
base_ANCOMBC <- set_ANCOM(pseudo_count = FALSE, fix_formula = "group", 
    contrast = c("group", "B", "A"), BC = TRUE, expand = FALSE)
many_ANCOMs <- set_ANCOM(pseudo_count = c(TRUE, FALSE), 
    fix_formula = "group", contrast = c("group", "B", "A"), 
    struc_zero = c(TRUE, FALSE), BC = c(TRUE, FALSE))
}
\seealso{
\code{\link{DA_ANCOM}}
}
