% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIEC.R
\name{createTIEC}
\alias{createTIEC}
\title{createTIEC}
\usage{
createTIEC(object)
}
\arguments{
\item{object}{Output of the differential abundance tests on mock comparisons.
Must follow a specific structure with comparison, method, matrix of
p-values, and method's name (See vignette for detailed information).}
}
\value{
A \code{list} of \code{data.frame}s:
\describe{
    \item{\code{df_pval}}{ 5 columns per number_of_features x methods x
    comparisons rows data.frame. The four columns are called Comparison,
    Method, variable (containing the feature names), pval, and padj;}
    \item{\code{df_FPR}}{ 5 columns per methods x comparisons rows 
    data.frame. For each set of method and comparison, the proportion of 
    false positives, considering 3 thresholds (0.01, 0.05, 0.1) are 
    reported;}
    \item{\code{df_FDR}}{ 4 columns per methods rows data.frame. For each 
    method, the average proportion of mock comparisons where false positives
    are found, considering 3 thresholds (0.01, 0.05, 0.1), are reported. 
    Each value is an estimate of the nominal False Discovery Rate (FDR);}
    \item{\code{df_QQ}}{ contains the coordinates to draw the QQ-plot to
    compare the mean observed p-value distribution across comparisons, with
    the theoretical uniform distribution;}
    \item{\code{df_KS}}{ 5 columns and methods x comparisons rows data.frame.
    For each set of method and comparison, the Kolmogorov-Smirnov test
    statistics and p-values are reported in KS and KS_pval columns
    respectively.}}
}
\description{
Extract the list of p-values from the outputs of the differential abundance
detection methods to compute several statistics to study the ability to
control the type I error and the p-values distribution.
}
\examples{
# Load some data
data(ps_stool_16S)

# Generate the patterns for 10 mock comparison for an experiment
# (N = 1000 is suggested)
mocks <- createMocks(nsamples = phyloseq::nsamples(ps_stool_16S), N = 10)
head(mocks)

# Add some normalization/scaling factors to the phyloseq object
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))
ps_stool_16S <- runNormalizations(normalization_list = my_norm,
    object = ps_stool_16S)

# Initialize some limma based methods
my_limma <- set_limma(design = ~ group, coef = 2,
    norm = c("TMM", "CSS"))

# Run methods on mock datasets
results <- runMocks(mocks = mocks, method_list = my_limma,
    object = ps_stool_16S)

# Prepare results for Type I Error Control
TIEC_summary <- createTIEC(results)

# Plot the results
plotFPR(df_FPR = TIEC_summary$df_FPR)
plotFDR(df_FDR = TIEC_summary$df_FDR)
plotQQ(df_QQ = TIEC_summary$df_QQ, zoom = c(0, 0.1))
plotKS(df_KS = TIEC_summary$df_KS)
plotLogP(df_QQ = TIEC_summary$df_QQ)
}
\seealso{
\code{\link{createMocks}}
}
