% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_dearseq.R
\name{DA_dearseq}
\alias{DA_dearseq}
\title{DA_dearseq}
\usage{
DA_dearseq(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  covariates = NULL,
  variables2test = NULL,
  sample_group = NULL,
  test = c("permutation", "asymptotic"),
  preprocessed = FALSE,
  n_perm = 1000,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{covariates}{a character vector containing the colnames of the 
covariates to include in the model.}

\item{variables2test}{a character vector containing the colnames of the 
variable of interest.}

\item{sample_group}{a vector of length \code{n} indicating whether the samples
should be grouped (e.g. paired samples or longitudinal data). Coerced
to be a \code{factor}. Default is \code{NULL} in which case no grouping is
performed.}

\item{test}{a character string indicating which method to use to approximate 
the variance component score test, either 'permutation' or 'asymptotic'
(default \code{test = "permutation"}).}

\item{preprocessed}{a logical flag indicating whether the expression data have
already been preprocessed (e.g. log2 transformed). Default is \code{FALSE}, in
which case \code{y} is assumed to contain raw counts and is normalized into
log(counts) per million.}

\item{n_perm}{the number of perturbations. Default is \code{1000}}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo` which are still the 
p-values as this method does not produce other values, and a suggested 
`name` of the final object considering the parameters passed to the 
function.
}
\description{
Fast run for dearseq differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
    "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
     phyloseq::sample_data(metadata))
# Differential abundance
DA_dearseq(object = ps, pseudo_count = FALSE, covariates = NULL, 
    variables2test = "group", sample_group = NULL, test = "asymptotic",
    preprocessed = FALSE, verbose = TRUE)
}
\seealso{
\code{\link[dearseq]{dear_seq}} for analysis of differential 
expression/abundance through a variance component test.
}
