% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgeR.R
\name{edgeROne}
\alias{edgeROne}
\title{Run edgeR for one sample against all the beads-only samples.}
\usage{
edgeROne(object, sample, beads, common.disp, tagwise.disp, trended.disp)
}
\arguments{
\item{object}{\code{\link[PhIPData]{PhIPData}} object}

\item{sample}{sample name of the sample to compare against beads-only samples}

\item{beads}{sample names for beads-only samples}

\item{common.disp}{edgeR estimated common dispersion parameter}

\item{tagwise.disp}{edgeR estimated tagwise dispersion parameter}

\item{trended.disp}{edgeR estimated trended dispersion parameter}
}
\value{
list with sample name, log2 fc estimate, and log10 p-value
}
\description{
This function is not really for external use. It's exported for
parallelization purposes. For more detailed descriptions see
\code{\link{runEdgeR}}.
}
\examples{
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

beads_disp <- beer:::.edgeRBeads(sim_data)
edgeROne(
    sim_data, "9", colnames(sim_data)[sim_data$group == "beads"],
    beads_disp$common.dispersion, beads_disp$tagwise.disp,
    beads_disp$trended.disp
)
}
