% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessEnriched.R
\name{.guessEnrichedMLE}
\alias{.guessEnrichedMLE}
\title{Guess enriched peptides based on MLE estimates of the true fold-change}
\usage{
.guessEnrichedMLE(object, beads.prior, threshold = 15)
}
\arguments{
\item{object}{\code{\link[PhIPData]{PhIPData}} object.}

\item{beads.prior}{data.frame of prior parameters for beads-only samples.}

\item{threshold}{minimum estimated fc for a peptide to be considered
super-enriched.}
}
\value{
logical matrix of the with the same dimensions as \code{object}
indicating which peptides are considered super-enriched.
}
\description{
Guess enriched peptides based on MLE estimates of the true fold-change
}
