% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializeCpp.R
\name{initializeCpp}
\alias{initializeCpp}
\alias{initializeCpp,TileDBArraySeed-method}
\title{Initialize TileDB-backed matrices}
\usage{
\S4method{initializeCpp}{TileDBArraySeed}(
  x,
  tiledb.cache.size = getAutoBlockSize(),
  tiledb.realize = initializeOptions("realize"),
  tiledb.realize.num.threads = initializeOptions("realize.num.threads"),
  tiledb.concurrency.level = initializeOptions("concurrency.level"),
  ...
)
}
\arguments{
\item{x}{A \pkg{TileDBArray} seed object.}

\item{tiledb.cache.size}{Integer scalar specifying the size of the cache in bytes during data extraction from a TileDB matrix.
Larger values reduce disk I/O during random access to the matrix, at the cost of increased memory usage.}

\item{tiledb.realize}{See the \code{realize} option in \code{\link{initializeOptions}}.}

\item{tiledb.realize.num.threads}{See the \code{realize.num.threads} option in \code{\link{initializeOptions}}.}

\item{tiledb.concurrency.level}{See the \code{concurrency.level} option in \code{\link{initializeOptions}}.}

\item{...}{Further arguments, ignored.}
}
\value{
An external pointer that can be used in any \pkg{tatami}-compatible function.
}
\description{
Initialize C++ representations of TileDB-backed matrices based on their \pkg{TileDBArray} representations.
}
\examples{
library(TileDBArray)
y <- matrix(runif(1000), ncol=20, nrow=50)
z <- as(y, "TileDBArray")
ptr <- initializeCpp(z)

}
\author{
Aaron Lun
}
