% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divideIntoBatches.R
\name{divideIntoBatches}
\alias{divideIntoBatches}
\title{Divide into batches}
\usage{
divideIntoBatches(x, batch, byrow = FALSE, restrict = NULL)
}
\arguments{
\item{x}{A matrix-like object where one dimension corresponds to cells and another represents features.}

\item{batch}{A factor specifying the batch to which each cell belongs.}

\item{byrow}{A logical scalar indicating whether rows correspond to cells.}

\item{restrict}{A subsetting vector specifying which cells should be used for correction.}
}
\value{
A list containing:
\itemize{
\item \code{batches}, a named list of matrix-like objects where each element corresponds to a level of \code{batch} and contains all cells from that batch.
\item \code{reorder}, an integer vector to be applied to the combined \code{batches} to recover the ordering of cells in \code{x}. 
\item \code{restricted}, a named list of integer vectors specifying which cells are to be used for correction.
Set to \code{NULL} if the input \code{restrict} was also \code{NULL}.
}
}
\description{
Divide a single input object into multiple separate objects according to their batch of origin.
}
\details{
This function is intended for internal use and other package developers.
It splits a single input object into multiple batches, allowing developers to use the same code for the scenario where \code{batch} is supplied with a single input.
}
\examples{
X <- matrix(rnorm(1000), ncol=100)
out <- divideIntoBatches(X, sample(3, 100, replace=TRUE))
names(out)

# Recovering original order.
Y <- do.call(cbind, out$batches)
Z <- Y[,out$reorder]
all.equal(Z, X) # should be TRUE.

}
\author{
Aaron Lun
}
