% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualityControlMetabolomics.R
\name{artmsQualityControlMetabolomics}
\alias{artmsQualityControlMetabolomics}
\title{Quality Control analysis of the evidence-like metabolomics dataset}
\usage{
artmsQualityControlMetabolomics(
  evidence_file,
  keys_file,
  met_exp = c("MV"),
  output_name = "qcPlots_metab",
  plotINTDIST = FALSE,
  plotCORMAT = TRUE,
  plotINTMISC = TRUE,
  printPDF = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{evidence_file}{(char or data.frame) The evidence file path and name, or
data.frame}

\item{keys_file}{(char or data.frame) The keys file path and name or
data.frame}

\item{met_exp}{(char) Metabolomics experiment. Only one option available
(so far):
\itemize{
\item \code{MV}: Markview output
}}

\item{output_name}{(char) prefix output name (no extension).
Default: "qcPlots_metab"}

\item{plotINTDIST}{if \code{TRUE} (default) plots both \emph{Box-dot plot}
and \emph{Jitter plot} of biological replicates based on MS (raw)
intensity values.}

\item{plotCORMAT}{if \code{TRUE} (default) generates up to 3 pdf files for
technical replicates, biological replicates, and conditions. Each pdf file
contains:
\itemize{
\item \emph{Correlation matrix} for all the biological replicates using
MS Intensity values,
\item \emph{Clustering matrix} of the MS Intensities and correlation distribution
\item \emph{histogram} of the distribution of correlations
}}

\item{plotINTMISC}{if \code{TRUE} (default) plots several pages, including
bar plots of \emph{Total Sum of Intensities in BioReplicates},
\emph{Total Sum of Intensities in Conditions},
\emph{Total Feature Counts in BioReplicates},
\emph{Total Feature Counts in conditions} separated by categories
(INT: has a intensity value NOINT: no intensity value )
\emph{Box plots} of MS Intensity values per
biological replicates and conditions; \emph{bar plots} of total intensity
by bioreplicates and conditions; Barplots of
\emph{total feature counts} by bioreplicates and conditions.}

\item{printPDF}{If \code{TRUE} (default) prints out the pdfs. Warning: plot
objects are not returned due to the large number of them.}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
Quality control files and plots for metabolomics
}
\description{
Quality Control analysis of the evidence-like metabolomics
dataset
}
\examples{
# Testing that input arguments cannot be null
artmsQualityControlMetabolomics(evidence_file = NULL,
                 keys_file = NULL,
                 met_exp = "MV")
}
\keyword{QC,}
\keyword{control,}
\keyword{evidence,}
\keyword{metabolomics}
\keyword{quality,}
