% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{artmsMapUniprot2Entrez}
\alias{artmsMapUniprot2Entrez}
\title{Map GENE SYMBOL, NAME, AND ENTREZID to a vector of Uniprot IDS}
\usage{
artmsMapUniprot2Entrez(uniprotkb, species)
}
\arguments{
\item{uniprotkb}{(vector) Vector of UniprotKB IDs}

\item{species}{(char) The species name. Species currently supported
as part of artMS: check \code{?artmsIsSpeciesSupported()} to find out the
list of supported species`}
}
\value{
(data.frame) with ENTREZID and GENENAMES mapped on UniprotKB ids
}
\description{
Map GENE SYMBOL, NAME, AND ENTREZID to a vector of Uniprot IDS
}
\examples{
# Load an example with human proteins
exampleID <- c("Q6P996", "B1N8M6")
artmsMapUniprot2Entrez(uniprotkb = exampleID, 
                       species = "HUMAN")
}
\keyword{annotation,}
\keyword{ids}
