% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seq_data.R
\docType{data}
\name{anota2seq_data}
\alias{anota2seq_data}
\alias{anota2seq_data_P}
\alias{anota2seq_data_T}
\alias{anota2seq_pheno_vec}
\title{Sample data set for anota2seq}
\format{Eight samples were simulated from 2 sample classes ("control" and 
  "treatment"); both total mRNA (anota2seq_data_T) and paired translated mRNA
  (anota2seq_data_P) are provided together with a sample class vector
  (anota2seq_pheno_vec).
  
  anota2seq_data_T and anota2seq_data_P are 2 matrices with 10748 rows and 8 
  columns simulated to represent raw RNAseq counts from 8 samples (4 
  replicates of each condition) and 10748 mRNAs. Columns are ordered 
  according to the RNA type pairing i.e. column 1 of anota2seq_data_T is from 
  the same sample as column 1 of anota2seq_data_P etc.}
\source{
These data originate from the study by \cite{Oertlin et al.} which 
  compared methods for analysis of translatomes quantified by RNAseq.
}
\usage{
data(anota2seq_data)
}
\description{
Simulated data used to illustrate the anota2seq workflow.
}
\examples{
##load data set 
data(anota2seq_data)
##check dimensions
dim(anota2seq_data_P)
head(anota2seq_data_P)
dim(anota2seq_data_T)
head(anota2seq_data_T)
anota2seq_pheno_vec
  
}
\references{
Oertlin C. et al. Genome-wide analysis of differential 
  translation and differential translational buffering using anota2seq, 
  bioRxiv, 2017.
}
\keyword{datasets}
