% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqClasses.R
\docType{class}
\name{Anota2seqDataSet-class}
\alias{Anota2seqDataSet-class}
\alias{Anota2seqDataSet}
\title{Anota2seqDataSet class}
\description{
A S4 class to store and collect output from the anota2seq workflow.
}
\details{
The Anota2seqDataSet will be used to collect outputs of the 
\code{\link{anota2seqPerformQC}}, 
\code{\link{anota2seqResidOutlierTest}},\code{\link{anota2seqAnalyze}}, 
\code{\link{anota2seqSelSigGenes}} and \code{\link{anota2seqRegModes}} 
functions. The results that are collected in the Anota2seqDataSet can be 
accessed using the anota2seq.get methods. Furthermore show() gives an 
overview of the stored objects in the Anota2seqDataSet.
}
\section{Slots}{

\describe{
\item{\code{dataT}}{a matrix containing normalized data for total mRNA. Can be 
accessed using \code{\link{anota2seqGetNormalizedData}}.}

\item{\code{dataP}}{a matrix containing normalized data for translated mRNA. Can be 
accessed using \code{\link{anota2seqGetNormalizedData}}.}

\item{\code{phenoVec}}{a vector describing the sample class for each column of dataT 
and dataP. Can be accessed using \code{\link{anota2seqGetCovariates}}.}

\item{\code{batchVec}}{an optional vector describing a batch class for each column of
dataT and dataP. Can be accessed using 
\code{\link{anota2seqGetCovariates}}.}

\item{\code{contrasts}}{a matrix describing the contrasts to be used in the analysis.
Can be accessed using \code{\link{anota2seqGetContrasts}}.}

\item{\code{qualityControl}}{after running \code{anota2seqPerformQC}, its output will
be saved in this slot of the Anota2seqDataSet object. Can be accessed using
\code{\link{anota2seqGetQualityControl}}.}

\item{\code{residOutlierTest}}{after running \code{anota2seqResidOutlierTest}, its 
output will be saved in this slot of the Anota2seqDataSet object. Can be 
accessed using \code{\link{anota2seqGetResidOutlierTest}}.}

\item{\code{translatedmRNA}}{after running \code{\link{anota2seqAnalyze}} with 
analysis parameter set to "translated mRNA" (or 
\code{\link{anota2seqRun}}), its output (results of the differential 
expression analysis) will be saved in this slot of the Anota2seqDataSet 
object. Can be accessed using \code{\link{anota2seqGetOutput}} with 
analysis = "translated mRNA" and output = "full".}

\item{\code{totalmRNA}}{after running \code{\link{anota2seqAnalyze}} with analysis 
parameter set to "total mRNA" (or \code{\link{anota2seqRun}}), its output 
(results of the differential expression analysis) will be saved in this 
slot of the Anota2seqDataSet object. Can be accessed using 
\code{\link{anota2seqGetOutput}} with analysis = "total mRNA" and output 
= "full".}

\item{\code{translation}}{after running \code{\link{anota2seqAnalyze}} with analysis 
parameter set to "translation" (or \code{\link{anota2seqRun}}), its 
output (results of the analysis of changes in translational efficiency 
leading to altered protein levels) will be saved in this slot of the 
Anota2seqDataSet object. Can be accessed using 
\code{\link{anota2seqGetOutput}} with analysis = "translation" and output
= "full".}

\item{\code{buffering}}{after running \code{\link{anota2seqAnalyze}} with analysis 
parameter set to "buffering" (or \code{\link{anota2seqRun}}), its 
output (results of the analysis of changes in translational efficiency 
leading to buffering) will be saved in this slot of the Anota2seqDataSet 
object. Can be accessed using \code{\link{anota2seqGetOutput}} with 
analysis = "buffering" and output = "full".}

\item{\code{selectedTranslatedmRNA}}{after running \code{\link{anota2seqSelSigGenes}}
with analysis parameter set to "translated mRNA" (or 
\code{\link{anota2seqRun}}), its output (results of the differential 
expression analysis on selected genes based on user defined thresholds in 
\code{anota2seqSelSigGenes}) will be saved in this slot of the 
Anota2seqDataSet object. Can be accessed using 
\code{\link{anota2seqGetOutput}} with analysis = "translated mRNA" and 
output = "selected".}

\item{\code{selectedTotalmRNA}}{after running \code{\link{anota2seqSelSigGenes}} with
analysis parameter set to "total mRNA" (or \code{\link{anota2seqRun}}), its
output (results of the differential expression analysis on selected genes 
based on user defined thresholds in \code{anota2seqSelSigGenes}) will be 
saved in this slot of the Anota2seqDataSet object. Can be accessed using 
\code{\link{anota2seqGetOutput}} with analysis = "total mRNA" and output 
= "selected".}

\item{\code{selectedTranslation}}{after running \code{\link{anota2seqSelSigGenes}} 
with analysis parameter set to "translation" (or 
\code{\link{anota2seqRun}}), its output (results of the analysis of changes
in translational efficiency leading to altered protein levels on selected 
genes) will be saved in this slot of the Anota2seqDataSet object. Can be 
accessed using \code{\link{anota2seqGetOutput}} with analysis = 
"translation" and output = "selected".}

\item{\code{selectedBuffering}}{after running \code{\link{anota2seqSelSigGenes}} with
analysis parameter set to "buffering" (or \code{\link{anota2seqRun}}), its 
output (results of the analysis of changes in translational efficiency 
leading to buffering on selected genes) will be saved in this slot of the 
Anota2seqDataSet object. Can be accessed using 
\code{\link{anota2seqGetOutput}} with analysis = "buffering" and output =
"selected".}

\item{\code{mRNAAbundance}}{after running \code{\link{anota2seqRegModes}} (or 
\code{\link{anota2seqRun}}), its output will be saved in this slot of the 
Anota2seqDataSet object. This output will contains results of the 
differential expression analysis on genes selected to be considered as 
regulated by mRNA abundance. The definition of regulation by mRNA abundance
can be based on results from total mRNA, translated mRNA or both (this is
set by the user on parameter mRNASelect in anota2seqRegModes). Statistics
results from mRNA type(s) considered in this definition will be saved in
this slot. Can be accessed using \code{\link{anota2seqGetOutput}} with
analysis = "mRNA abundance" and output = "selected".}

\item{\code{deltaData}}{after running \code{\link{anota2seqAnalyze}}, an 
additional output called deltaData will be stored in the Anota2seqDataSet. 
deltaData is a list of matrices with one deltaData matrix for each contrast. 
For each matrix the rows correspond to the mRNA in the dataset and has the 
following columns: deltaP, deltaT, deltaPT and deltaTP. deltaP is translated 
mRNA fold change, deltaT is the total mRNA fold change, deltaPT is the within 
contrast difference difference of the log ratios with translated mRNA in the 
nominator and total mRNA in the denominator (deltaPT is commonly called TE score
= Translational efficiency score) and deltaTP is the within contrast difference 
of the log ratios with total mRNA in the nominator and translated mRNA in the 
denominator.}
}}

