% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plot_coannotations}
\alias{plot_coannotations}
\title{Plot pair-wise annotations across regions}
\usage{
plot_coannotations(
  annotated_regions,
  annotation_order = NULL,
  plot_title,
  axes_label,
  quiet = FALSE
)
}
\arguments{
\item{annotated_regions}{The \code{GRanges} result of \code{annotate_regions()}.}

\item{annotation_order}{A character vector which doubles as the subset of annotations desired for plot as well as the ordering. If \code{NULL}, all annotations are displayed.}

\item{plot_title}{A string used for the title of the plot. If missing, no plot title label is displayed.}

\item{axes_label}{A string used for the axis labels. If missing, corresponding variable name used.}

\item{quiet}{Print progress messages (FALSE) or not (TRUE).}
}
\value{
A \code{ggplot} object which can be viewed by calling it, saved with \code{ggplot2::ggsave}, or edited.
}
\description{
All co-occurring annotations associated with a region are computed and displayed as a heatmap.
}
\details{
As with \code{plot_annotation()}, the number in each cell is the number of unique regions annotated to the pair of annotations.

For example, if a region is annotated to both a CpG shore and to two different exons simultaneously, the region will only be counted once in the CpG shore / exon cell. NOTE, this same region will count once in both the CpG shore and exon cells on the diagonal.
}
\examples{
   # Get premade CpG annotations
   data('annotations', package = 'annotatr')

   dm_file = system.file('extdata', 'IDH2mut_v_NBM_multi_data_chr9.txt.gz', package = 'annotatr')
   extraCols = c(diff_meth = 'numeric', mu1 = 'numeric', mu0 = 'numeric')
   dm_regions = read_regions(con = dm_file, extraCols = extraCols,
       rename_score = 'pval', rename_name = 'DM_status', format = 'bed')
   dm_regions = dm_regions[1:1000]

   dm_annots = annotate_regions(
       regions = dm_regions,
       annotations = annotations,
       ignore.strand = TRUE)

   all_order = c(
       'hg19_cpg_islands',
       'hg19_cpg_shores',
       'hg19_cpg_shelves',
       'hg19_cpg_inter')

   dm_vs_ca = plot_coannotations(
       annotated_regions = dm_annots,
       annotation_order = all_order,
       axes_label = 'Annotations',
       plot_title = 'Co-occurrence of Annotations')

}
