% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_h5ad.R
\name{read_h5ad}
\alias{read_h5ad}
\title{Read H5AD}
\usage{
read_h5ad(
  path,
  as = c("InMemoryAnnData", "HDF5AnnData", "SingleCellExperiment", "Seurat"),
  mode = c("r", "r+", "a", "w", "w-", "x"),
  ...
)
}
\arguments{
\item{path}{Path to the H5AD file to read}

\item{as}{The type of object to return. One of:
\itemize{
\item \code{"InMemoryAnnData"}: Read the H5AD file into memory as an
\code{\link{InMemoryAnnData}} object
\item \code{"HDF5AnnData"}: Read the H5AD file as an \code{\link{HDF5AnnData}} object
\item \code{"SingleCellExperiment"}: Read the H5AD file as a
\code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}} object
\item \code{"Seurat"}: Read the H5AD file as a
\code{\link[SeuratObject:Seurat-class]{SeuratObject::Seurat}} object
}}

\item{mode}{The mode to open the HDF5 file.
\itemize{
\item \code{a} creates a new file or opens an existing one for read/write.
\item \code{r} opens an existing file for reading.
\item \verb{r+} opens an existing file for read/write.
\item \code{w} creates a file, truncating any existing ones.
\item \verb{w-}/\code{x} are synonyms, creating a file and failing if it already exists.
}}

\item{...}{Extra arguments provided to the \verb{as_*} conversion function for the
object specified by \code{as}}
}
\value{
The object specified by \code{as}
}
\description{
Read data from a H5AD file
}
\examples{
h5ad_file <- system.file("extdata", "example.h5ad", package = "anndataR")

# Read the H5AD as a SingleCellExperiment object
if (requireNamespace("SingleCellExperiment", quietly = TRUE)) {
  sce <- read_h5ad(h5ad_file, as = "SingleCellExperiment")
}

# Read the H5AD as a Seurat object
if (requireNamespace("SeuratObject", quietly = TRUE)) {
  seurat <- read_h5ad(h5ad_file, as = "Seurat")
}
}
\seealso{
Other AnnData creators: 
\code{\link{AnnData}()},
\code{\link{as_AnnData}()}
}
\concept{AnnData creators}
