% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReticulateAnnData.R
\name{as_ReticulateAnnData}
\alias{as_ReticulateAnnData}
\title{Convert an \code{AnnData} to a \code{ReticulateAnnData}}
\usage{
as_ReticulateAnnData(adata)
}
\arguments{
\item{adata}{An \code{AnnData} object to be converted to \code{\link{ReticulateAnnData}}}
}
\value{
A \code{\link{ReticulateAnnData}} object with the same data as the input
\code{AnnData} object
}
\description{
Convert another \code{AnnData} object to a \code{\link{ReticulateAnnData}} object
}
\examples{
\donttest{
# Requires Python anndata to be installed
if (requireNamespace("reticulate", quietly = TRUE) &&
      reticulate::py_module_available("anndata")) {
  ad <- AnnData(
    X = matrix(1:5, 3L, 5L),
    layers = list(
      A = matrix(5:1, 3L, 5L),
      B = matrix(letters[1:5], 3L, 5L)
    ),
    obs = data.frame(row.names = LETTERS[1:3], cell = 1:3),
    var = data.frame(row.names = letters[1:5], gene = 1:5)
  )
  ad$as_ReticulateAnnData()
}
}
}
\seealso{
Other object converters: 
\code{\link{as_AnnData}()},
\code{\link{as_HDF5AnnData}()},
\code{\link{as_InMemoryAnnData}()},
\code{\link{as_Seurat}()},
\code{\link{as_SingleCellExperiment}()},
\code{\link{reticulate-helpers}}
}
\concept{object converters}
\keyword{internal}
