% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDF5AnnData.R
\name{as_HDF5AnnData}
\alias{as_HDF5AnnData}
\title{Convert an \code{AnnData} to an \code{HDF5AnnData}}
\usage{
as_HDF5AnnData(
  adata,
  file,
  compression = c("none", "gzip", "lzf"),
  mode = c("w-", "r", "r+", "a", "w", "x")
)
}
\arguments{
\item{adata}{An \code{AnnData} object to be converted to \code{\link{HDF5AnnData}}}

\item{file}{The file name (character) of the \code{.h5ad} file}

\item{compression}{The compression algorithm to use when writing the
HDF5 file. Can be one of \code{"none"}, \code{"gzip"} or \code{"lzf"}. Defaults to
\code{"none"}.}

\item{mode}{The mode to open the HDF5 file:
\itemize{
\item \code{a} creates a new file or opens an existing one for read/write
\item \code{r} opens an existing file for reading
\item \verb{r+} opens an existing file for read/write
\item \code{w} creates a file, truncating any existing ones
\item \verb{w-}/\code{x} are synonyms, creating a file and failing if it already exists
}}
}
\value{
An \code{\link{HDF5AnnData}} object with the same data as the input \code{AnnData}
object.
}
\description{
Convert another \code{AnnData} object to an \code{\link{HDF5AnnData}} object
}
\seealso{
Other object converters: 
\code{\link{as_AnnData}()},
\code{\link{as_InMemoryAnnData}()},
\code{\link{as_ReticulateAnnData}()},
\code{\link{as_Seurat}()},
\code{\link{as_SingleCellExperiment}()},
\code{\link{reticulate-helpers}}
}
\concept{object converters}
\keyword{internal}
