% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractAnnData-s3methods.R
\name{AbstractAnnData-s3methods}
\alias{AbstractAnnData-s3methods}
\alias{dim.AbstractAnnData}
\alias{nrow.AbstractAnnData}
\alias{ncol.AbstractAnnData}
\alias{dimnames.AbstractAnnData}
\alias{dimnames<-.AbstractAnnData}
\alias{[.AbstractAnnData}
\title{S3 Methods for AbstractAnnData Objects}
\usage{
\method{dim}{AbstractAnnData}(x)

\method{nrow}{AbstractAnnData}(x)

\method{ncol}{AbstractAnnData}(x)

\method{dimnames}{AbstractAnnData}(x)

\method{dimnames}{AbstractAnnData}(x) <- value

\method{[}{AbstractAnnData}(x, i, j, drop = TRUE, ...)
}
\arguments{
\item{x}{An AbstractAnnData object}

\item{value}{For \verb{dimnames<-}: A list of two character vectors (obs_names, var_names)}

\item{i}{Row indices (observations). Can be numeric, logical, or character.}

\item{j}{Column indices (variables). Can be numeric, logical, or character.}

\item{drop}{Ignored (for compatibility with generic)}

\item{...}{Additional arguments passed to methods}
}
\value{
\itemize{
\item \code{dim}: Numeric vector of length 2 (n_obs, n_vars)
\item \code{nrow}, \code{ncol}: Integer count
\item \code{dimnames}: List with obs_names and var_names
\item \code{rownames}, \code{colnames}: Character vector
\item \verb{dimnames<-}, \verb{rownames<-}, \verb{colnames<-}: The modified object (invisibly)
\item \code{[}: A AnnDataView object with the specified subset
}
}
\description{
These S3 methods provide standard R interfaces for AbstractAnnData objects,
making them behave like native R objects with familiar syntax.
}
\details{
\strong{Subsetting behaviour}: The \code{[} method supports logical, integer, and character
subsetting for both observations (rows) and variables (columns). However, unlike
standard R behaviour:
\itemize{
\item Logical vectors are \strong{not recycled} and must have the exact same length as
the dimension being subset
\item \strong{Negative indices are not supported} (R's "exclude these" syntax)
}

These design choices ensure clear and predictable subsetting behaviour for
biological data matrices, avoiding potential confusion from accidental recycling
or exclusion patterns.

The following S3 methods are available:
\itemize{
\item \code{dim(x)}: Get dimensions (n_obs, n_vars), equivalent to \code{x$shape()}
\item \code{nrow(x)}: Get number of observations, equivalent to \code{x$n_obs()}
\item \code{ncol(x)}: Get number of variables, equivalent to \code{x$n_vars()}
\item \code{dimnames(x)}: Get dimension names, (obs_names, var_names)
\item \code{rownames(x)}: Get observation names, equivalent to \code{x$obs_names()}
\item \code{colnames(x)}: Get variable names, equivalent to \code{x$var_names()}
\item \code{dimnames(x) <- value}: Set dimension names
\item \code{rownames(x) <- value}: Set observation names, equivalent to \code{x$obs_names() <- ...}
\item \code{colnames(x) <- value}: Set variable names, equivalent to \code{x$var_names() <- ...}
\item \code{x[i, j]}: Subset observations and/or variables
}
}
\examples{
# Create example data
ad <- generate_dataset(n_obs = 100, n_vars = 50, format = "AnnData")

# Standard R methods work
dim(ad)
nrow(ad)
ncol(ad)
dimnames(ad)
rownames(ad)
colnames(ad)

# Set names using dimnames
dimnames(ad) <- list(
  paste0("cell_", 1:nrow(ad)),
  paste0("gene_", 1:ncol(ad))
)

# Or set names individually (uses dimnames<- internally)
rownames(ad) <- paste0("cell_", 1:nrow(ad))
colnames(ad) <- paste0("gene_", 1:ncol(ad))

# Subsetting creates AnnDataView
subset_ad <- ad[1:10, 1:5]
subset_ad <- ad[rep(c(TRUE, FALSE), length.out = nrow(ad)), ]  # logical subsetting (no recycling)
subset_ad <- ad[c("cell_1", "cell_2"), c("gene_1", "gene_2")]  # name subsetting
}
