% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_plots.R
\name{waffle}
\alias{waffle}
\title{Create a Waffle Chart using ggplot2}
\usage{
waffle(parts, rows = 10, title = NULL, colors = NULL, legend_pos = "bottom")
}
\arguments{
\item{parts}{A named numeric vector where names are the categories and
values are the number of squares to be plotted for each category.}

\item{rows}{The number of rows in the waffle grid. The number of columns will
be calculated based on the total number of squares.}

\item{title}{A string for the plot title.}

\item{colors}{A character vector of colors to use for the different categories.
The number of colors should match the number of categories in `parts`.}

\item{legend_pos}{The position of the legend (e.g., "bottom", "right", "none").}
}
\value{
A ggplot object representing the waffle chart.
}
\description{
This function generates a waffle chart, which is a grid of squares showing
parts of a whole. It's a simple replacement for the deprecated 'waffle' package
for basic use cases.
}
\examples{
read_q_per <- c("Good Reads\n100 (80\%)" = 80, "Bad Reads\n25 (20\%)" = 20)
waffle(
  parts = read_q_per,
  rows = 10,
  title = "Quality of all reads",
  colors = c('#E69F00', '#000000')
)

}
