% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_plots.R
\name{plot_variants}
\alias{plot_variants}
\title{Plots most frequent variants using ggplot2.}
\usage{
plot_variants(
  alignments,
  config,
  id,
  cut_buffer = 5,
  top = 10,
  annot = if (amplican::get_seq(config, id, "Donor") == "") "cov" else NA,
  summary_plot = amplican::get_seq(config, id, "Donor") == "",
  frameshift = amplican::get_seq(config, id, "Donor") == ""
)
}
\arguments{
\item{alignments}{(data.frame) Loaded alignment information from
alignments_events.csv file.}

\item{config}{(data.frame) Loaded table from config_summary.csv file.}

\item{id}{(string or vector of strings) Name of the ID column from config
file or name of multiple IDs if it is possible to group them. First amplicon
will be used as the basis for plot. If Donor is available we will try to add the first
donor and mark it on the plot.}

\item{cut_buffer}{(numeric) Default is 5, you should specify the same as
used in the analysis.}

\item{top}{(numeric) Specify number of most frequent reads to plot. By
default it is 10. Check \code{\link{plot_heterogeneity}} to see how many
reads will be enough to give good overview of your variants.}

\item{annot}{("codon" or "cov" or NA) What to display for
annotation top plot. When NA will not display anything, also not display
total summary. Codon plot is all reading frames for a given window, and the default
"cov" is coverage of all indels and mismatches over a given window.}

\item{summary_plot}{(boolean) Whether small summary plot in the upper right
corner should be displayed. Top bar summarizes total reads with
frameshift (F), reads with Edits without Frameshift (Edits) and reads
without Edits (Match).}

\item{frameshift}{(boolean) Whether to include Frameshift column in the table.
\preformatted{
annot            on    | off
}}
}
\value{
(variant plot) gtable object of variants plot
}
\description{
This function plots variants in relation to the amplicon. Shows sequences of
top mutants without aggregating on deletions, insertions and mismatches.
}
\details{
Top plot shows all six possible frames for given amplicon. Amino acids are
colored as follows:\cr
\tabular{rrrrr}{
Small nonpolar \tab G, A, S, T \tab Orange\cr
Hydrophobic \tab C, V, I, L, P, F, Y, M, W	\tab Green\cr
Polar \tab N, Q, H \tab Magenta\cr
Negatively charged \tab D, E \tab Red\cr
Positively charged \tab K, R \tab Blue\cr
Other \tab eg. *, U, + \tab Grey
}
Variant plot shows amplicon reference, UPPER letters which were the basis for
window selection are highlighted with dashed white box (guideRNA). Black
triangles are reflecting insertion points. Dashed letters indicate deletions.
Table associated with variant plot represents:
\describe{
\item{Freq - }{Frequency of given read in experiment. Variants are ordered by
frequency value.}
\item{Count - }{Represents raw count of this variant reads in experiment.}
\item{F - }{Sum of deletion and insertion widths of events overlapping
presented window. Green background indicates frameshift. }}
}
\examples{
#example config
config <- read.csv(system.file("extdata", "results", "config_summary.csv",
                               package = "amplican"))
#example alignments results
alignments_file <- system.file("extdata", "results", "alignments",
                               "events_filtered_shifted_normalized.csv",
                               package = "amplican")
alignments <- read.csv(alignments_file)

alignments <- alignments[alignments$consensus & alignments$overlaps, ]
p <- plot_variants(alignments[alignments$consensus & alignments$overlaps, ],
                   config, c('ID_1','ID_3'))
# with Donor we dont plot summary and the annot, summary plot and frameshift
p <- plot_variants(alignments[alignments$consensus & alignments$overlaps, ],
                   config, c('ID_5'))

}
\seealso{
Other specialized plots: 
\code{\link{metaplot_deletions}()},
\code{\link{metaplot_insertions}()},
\code{\link{metaplot_mismatches}()},
\code{\link{plot_cuts}()},
\code{\link{plot_deletions}()},
\code{\link{plot_heterogeneity}()},
\code{\link{plot_insertions}()},
\code{\link{plot_mismatches}()}
}
\concept{specialized plots}
