% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlignmentsExperimentSet-class.R
\docType{class}
\name{AlignmentsExperimentSet-class}
\alias{AlignmentsExperimentSet-class}
\alias{AlignmentsExperimentSet}
\alias{length,AlignmentsExperimentSet-method}
\alias{fwdReads,AlignmentsExperimentSet-method}
\alias{fwdReads<-,AlignmentsExperimentSet-method}
\alias{rveReads,AlignmentsExperimentSet-method}
\alias{rveReads<-,AlignmentsExperimentSet-method}
\alias{fwdReadsType,AlignmentsExperimentSet-method}
\alias{fwdReadsType<-,AlignmentsExperimentSet-method}
\alias{rveReadsType,AlignmentsExperimentSet-method}
\alias{rveReadsType<-,AlignmentsExperimentSet-method}
\alias{unassignedData,AlignmentsExperimentSet-method}
\alias{unassignedData<-,AlignmentsExperimentSet-method}
\alias{readCounts,AlignmentsExperimentSet-method}
\alias{readCounts<-,AlignmentsExperimentSet-method}
\alias{experimentData,AlignmentsExperimentSet-method}
\alias{experimentData<-,AlignmentsExperimentSet-method}
\alias{barcodeData,AlignmentsExperimentSet-method}
\alias{barcodeData<-,AlignmentsExperimentSet-method}
\alias{unassignedCount,AlignmentsExperimentSet-method}
\alias{assignedCount,AlignmentsExperimentSet-method}
\alias{names,AlignmentsExperimentSet-method}
\alias{c,AlignmentsExperimentSet-method}
\alias{[,AlignmentsExperimentSet,numeric,missing,missing-method}
\alias{as.list.AlignmentsExperimentSet}
\alias{$,AlignmentsExperimentSet-method}
\alias{writeAlignments,AlignmentsExperimentSet-method}
\alias{lookupAlignment,AlignmentsExperimentSet-method}
\alias{extractEvents,AlignmentsExperimentSet-method}
\title{An S4 class to represent alignments from multiple experiments}
\usage{
AlignmentsExperimentSet(...)

\S4method{length}{AlignmentsExperimentSet}(x)

\S4method{fwdReads}{AlignmentsExperimentSet}(x)

\S4method{fwdReads}{AlignmentsExperimentSet}(x) <- value

\S4method{rveReads}{AlignmentsExperimentSet}(x)

\S4method{rveReads}{AlignmentsExperimentSet}(x) <- value

\S4method{fwdReadsType}{AlignmentsExperimentSet}(x)

\S4method{fwdReadsType}{AlignmentsExperimentSet}(x) <- value

\S4method{rveReadsType}{AlignmentsExperimentSet}(x)

\S4method{rveReadsType}{AlignmentsExperimentSet}(x) <- value

\S4method{unassignedData}{AlignmentsExperimentSet}(x)

\S4method{unassignedData}{AlignmentsExperimentSet}(x) <- value

\S4method{readCounts}{AlignmentsExperimentSet}(x)

\S4method{readCounts}{AlignmentsExperimentSet}(x) <- value

\S4method{experimentData}{AlignmentsExperimentSet}(x)

\S4method{experimentData}{AlignmentsExperimentSet}(x) <- value

\S4method{barcodeData}{AlignmentsExperimentSet}(x)

\S4method{barcodeData}{AlignmentsExperimentSet}(x) <- value

\S4method{unassignedCount}{AlignmentsExperimentSet}(x)

\S4method{assignedCount}{AlignmentsExperimentSet}(x)

\S4method{names}{AlignmentsExperimentSet}(x)

\S4method{c}{AlignmentsExperimentSet}(x, ...)

\S4method{[}{AlignmentsExperimentSet,numeric,missing,missing}(x, i, j, ..., drop = TRUE)

\method{as.list}{AlignmentsExperimentSet}(x, ...)

\S4method{$}{AlignmentsExperimentSet}(x, name)

\S4method{writeAlignments}{AlignmentsExperimentSet}(x, file = "", aln_format = "txt")

\S4method{lookupAlignment}{AlignmentsExperimentSet}(x, ID, read_id = 1)

\S4method{extractEvents}{AlignmentsExperimentSet}(object, use_parallel = FALSE)
}
\arguments{
\item{...}{pass any number of AlignmentsExperimentSet objects, make sure
experiment IDs can be unique after merging}

\item{x, object}{(AlignmentsExperimentSet)}

\item{value}{Represents assignment values for setter methods.}

\item{i, j, name, drop}{(numeric, missing, character, missing)
AlignmentsExperimentSet object can be subsetted using
names of the experiments eg. \code{x$name} or \code{x[i]}, resulting in
AlignmentsExperimentSet object that has only one experiment. During this
subsetting, values of unassignedData and barcodeData are dropped.}

\item{file}{(connection or string) Destination file. When empty, defaults to
standard output.}

\item{aln_format}{("txt" or "fasta") Specifies format of the file.}

\item{ID}{(string) Experiment Identifier}

\item{read_id}{(numeric) Read Identifier. Reads are sorted by frequency.
Defaults to 1, most abundant read.}

\item{use_parallel}{(boolean) When using \code{extractEvents} you can
use multicore back-end through \code{\link[BiocParallel]{register}} as this
is very slow function (despite vectorization).}
}
\value{
depending on the function used
}
\description{
Class \code{AlignmentsExperimentSet} holds data from multiple alignments for
many experiments. Allows to examine alignments in great detail.
}
\section{Slots}{

\describe{
\item{\code{fwdReads,rveReads}}{(list) Named list where each element is of class
\code{\link[pwalign]{PairwiseAlignmentsSingleSubject}}. Names correspond
to the experiment ID. Contains alignments of reads against amplicons.}

\item{\code{fwdReadsType,rveReadsType}}{(list) Named list where each element is of
logical vector, so far TRUE corresponds to HDR events. Names correspond
to the experiment ID. Contains type of read - HDR/NHEJ.}

\item{\code{readCounts}}{(list) Named list where each element is numeric vector that
describes how many reads are compressed into unique representation
before alignment in \code{fwdReads} and/or \code{rveReads}.}

\item{\code{unassignedData}}{(data.frame) Contains reads that failed to be assigned
to any of the experiments. Alignment of forward against reverse reads may
give hint whether these reads are compromised in any way.}

\item{\code{experimentData}}{(data.frame) Expands on configuration file and provides
information about cut rates, frameshifts, PRIMER DIMER detection etc. Each
row corresponds to experiment ID.}

\item{\code{barcodeData}}{(data.frame) Information that is gathered on the barcode
level is gathered in this data.frame, mainly quality filtering statistics.}
}}

\section{View alignments}{

Write out all alignments in "fasta" or "txt" format.:  \cr
\code{writeAlignments(x, file = "", aln_format = "txt")}


Write out human readable alignments for given experiment and read_id.:  \cr
\code{lookupAlignment(x, ID, read_id = 1)}
}

\section{Coercion based on events}{

Coerce to \code{data.frame} compatible with
\code{\link[GenomicRanges]{GRanges}} .: \cr
as.data.frame(x)
}

\examples{
exampleAlignments <- pwalign::pairwiseAlignment(
  Biostrings::DNAStringSet(c("ACTGACTG", "CGACGACG")), "ACGTACGTACGT")
new("AlignmentsExperimentSet",
     fwdReads = list(ID_1 = exampleAlignments, ID_2 = exampleAlignments),
     rveReads = list(ID_1 = exampleAlignments, ID_2 = exampleAlignments),
     fwdReadsType = list(ID_1 = c(FALSE, FALSE), ID_2 = c(FALSE, FALSE)),
     rveReadsType = list(ID_1 = c(FALSE, FALSE), ID_2 = c(FALSE, FALSE)),
     readCounts = list(ID_1 = c(2, 20), ID_2 = c(30, 100)),
     unassignedData = NULL,
     experimentData = data.frame(ID = c("ID_1", "ID_2"),
                                 Barcode = c("B1", "B1"),
                                 whatever = c(50, 100)),
     barcodeData = data.frame(Barcode = "B1", statistic1 = 100))
# Coercion
extractEvents(AlignmentsExperimentSet())
GenomicRanges::GRanges(extractEvents(AlignmentsExperimentSet()))

}
\keyword{internal}
