% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlevinQuant.R
\name{plotAlevinQuant}
\alias{plotAlevinQuant}
\title{Panel of plots with quantification summary statistics}
\usage{
plotAlevinQuant(
  cbTable,
  colName = "inFinalWhiteList",
  cbName = "final whitelist",
  firstSelColName = "inFirstWhiteList"
)
}
\arguments{
\item{cbTable}{\code{data.frame} (such as the \code{cbTable} returned by
\code{readAlevinQC} or \code{readAlevinFryQC}) with collapsed barcode
frequencies, the total UMI count and the number of detected genes for
each cell.}

\item{colName}{Character scalar giving the name of a logical column of
\code{cbTable} to use for coloring the points.}

\item{cbName}{Character scalar giving the name of the set of barcodes
defined by \code{colName}, used for labelling the plot legend.}

\item{firstSelColName}{Character scalar indicating the name of the logical
column in \code{cbTable} that indicates the original selection of
barcodes for quantification.}
}
\value{
A ggplot object
}
\description{
Panel of plots with quantification summary statistics
}
\examples{
alevin <- readAlevinQC(system.file("extdata/alevin_example_v0.14",
                                   package = "alevinQC"))
plotAlevinQuant(alevin$cbTable, colName = "inFinalWhiteList",
                cbName = "final whitelist")

}
\author{
Charlotte Soneson
}
