% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GffFileReference.R
\docType{class}
\name{GffFileReference}
\alias{GffFileReference}
\alias{GffFileReference-class}
\alias{saveObject,GffFileReference-method}
\alias{readGffFileReference}
\alias{GffWrapper}
\alias{GffWrapper-class}
\alias{stageObject,GffWrapper-method}
\alias{loadGffWrapper}
\title{Reference to a GFF file}
\usage{
GffFileReference(path, index = NULL)
}
\arguments{
\item{path}{String containing the path to a Gzip- or BGZF-compressed GFF file.
The format is automatically detected from the file extension (\code{.gff2}, \code{.gff3} or \code{.gtf}).}

\item{index}{String specifying the path to a tabix file in tabix format, or \code{NULL} if no index is available.
If supplied, \code{path} should be coordinate-sorted and BGZF-compressed.}
}
\value{
A GffFileReference instance that can be used in \code{\link{saveObject}}.
}
\description{
Reference to a GFF2/3 file, for saving and loading in the \pkg{alabaster} framework.
}
\examples{
# Using rtracklayer's example GFF file.
src <- system.file("tests", "genes.gff3", package = "rtracklayer")
fl <- tempfile(fileext=".gff3.gz")
writeLines(con=gzfile(fl), readLines(src))

# Creating a GffFileReference.
wrapped <- GffFileReference(fl)
wrapped

# Saving it:
dir <- tempfile()
saveObject(wrapped, dir)
list.files(dir, recursive=TRUE)

# Loading it back again:
readObject(dir)

}
\author{
Aaron Lun
}
