% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_counts.R
\name{countsBySubject}
\alias{countsBySubject}
\title{Gene-by-subject count matrix}
\usage{
countsBySubject(scExp, subjectVar)
}
\arguments{
\item{scExp}{\linkS4class{SingleCellExperiment} object containing
(at minimum) gene counts and column metadata describing sample identifiers
and cell types.}

\item{subjectVar}{Metadata column name assigning biological sample
identity to aggregate within-subject feature counts.}
}
\value{
S4 DataFrame of gene-by-subject count sums.
}
\description{
Convert gene-by-cell count matrix to gene-by-subject count matrix.
Row sums are calculated for each feature (i.e. gene) across cells by subject.
}
\examples{
## Return cell count matrix aggregated by subject.
countsBySubject(scExp=small_airway, subjectVar="orig.ident")

}
\seealso{
\code{\link{scSubjects}} for \code{subjects} values.
}
