% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_bio_var.R
\name{countsByCell}
\alias{countsByCell}
\title{Within cell type gene-by-subject matrices}
\usage{
countsByCell(scExp, subjectVar, cellVar)
}
\arguments{
\item{scExp}{\linkS4class{SingleCellExperiment} object containing
(at minimum) gene counts and column metadata describing sample identifiers
and cell types.}

\item{subjectVar}{Metadata column name assigning biological sample
identity to aggregate within-subject feature counts.}

\item{cellVar}{Metadata column name assigning cell type. Used for
aggregating gene-by-subject count matrices by cell type.}
}
\value{
List of gene-by-subject and design matrices for each cell type.
}
\description{
Given a vector of unique cell types, calculate a gene-by-subject matrix and
inter-subject metadata for a differential expression design matrix.
}
\examples{
## Return list of `SummarizedExperiments` with gene-by-subject count matrices
## and subject metadata for each unique `SingleCellExperiment` cell type.
countsByCell(
    scExp=small_airway,
    subjectVar="orig.ident", cellVar="celltype"
)

}
\seealso{
\code{\link{summarizedCounts}} for aggregate counts and metadata
\linkS4class{SummarizedExperiment} object.
}
