% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/geneSetTables.R
\name{outputRomer}
\alias{outputRomer}
\alias{outputRomer,ExpressionSet,MArrayLM-method}
\alias{outputRomer,DGEList,DGEGLM-method}
\alias{outputRomer,EList,MArrayLM-method}
\title{A function to create HTML output from the results of running romer on a set
of contrasts.}
\usage{
outputRomer(object, fit, ...)

\S4method{outputRomer}{ExpressionSet,MArrayLM}(
  object,
  fit,
  rsltlst,
  genesetlst,
  design = NULL,
  contrast = NULL,
  changenames = TRUE,
  dir = "genesets",
  explanation = NULL,
  baseline.hmap = TRUE,
  file = "indexRomer.html",
  affy = TRUE,
  ...
)

\S4method{outputRomer}{DGEList,DGEGLM}(
  object,
  fit,
  rsltlst,
  genesetlst,
  design = NULL,
  contrast = NULL,
  changenames = TRUE,
  dir = "genesets",
  explanation = NULL,
  baseline.hmap = TRUE,
  file = "indexRomer.html",
  ...
)

\S4method{outputRomer}{EList,MArrayLM}(
  object,
  fit,
  rsltlst,
  genesetlst,
  design = NULL,
  contrast = NULL,
  changenames = TRUE,
  dir = "genesets",
  explanation = NULL,
  baseline.hmap = TRUE,
  file = "indexRomer.html",
  ...
)
}
\arguments{
\item{object}{An ExpressionSet, DGEList or EList object containing normalized, summarized
gene expression data.}

\item{fit}{An MArrayLM or DGEGLM object, containing the fitted data.}

\item{\dots}{Arguments to be passed to lower-level functions. See
\code{geneSetPage}, \code{dataAndHeatmapPage} and \code{gsHeatmap} for
available arguments.}

\item{rsltlst}{A list of results, generated by the \code{\link{romer}}
function. See discussion for more information.}

\item{genesetlst}{A list of genesets, usually created by loading in the
RData files that can be downloaded from
http://bioinf.wehi.edu.au/software/MSigDB/. See details for more
information.}

\item{design}{A design matrix describing the model.}

\item{contrast}{A contrast matrix describing the contrasts that were fit.
This matrix should have colnames, which will be used to name subdirectories
containing results.}

\item{changenames}{Boolean. When creating heatmaps of the gene sets, should
the columns be appended with the colnames from the design matrix? If
\code{FALSE}, the sampleNames will be used.}

\item{dir}{Character. The subdirectory to use for the output data. Defaults
to 'genesets'.}

\item{explanation}{If \code{NULL}, a generic paragraph will be placed at the
top of the indexRomer.html page, giving a brief explanation of the analysis.
Alternatively, this can be replaced with other text. Please note that this
text should conform to HTML standards (e.g., will be pasted into the HTML
document as-is, so should contain any required HTML markup).}

\item{baseline.hmap}{Boolean. If \code{TRUE}, then the resulting heatmaps
will be centered by subtracting the mean of the baseline sample. As an
example, in a contrast of treatment A - treatment B, the mean of the
treatment B samples will be subtracted. The heatmap colors then represent
the fold change between the A and B samples.}

\item{file}{Character. The filename to output. Defaults to
indexRomer.html.}

\item{affy}{Boolean. Are these Affymetrix arrays? if \code{TRUE}, then
thre will be links generated in the HTML table to the netaffx site.}
}
\value{
Nothing is returned. The function is run only for the side effect of
creating HTML tables with output for each significant gene set.
}
\description{
This function is actually intended to be a sub-function of \code{runRomer},
but can hypothetically run by itself if the \code{\link{romer}} step has
already been done.
}
\details{
This function is intended to be an internal function for \code{runRomer}.
However, it is possible that \code{runRomer} errored out after saving the
results from running \code{\link{romer}} on a set of contrasts, and all that
remains is to create the output HTML.

Please note that the first two arguments to this function have certain
expectations. The rsltlst should be the output from running
\code{\link{romer}}. If using the saved output from \code{runRomer}, one
should first \code{load} the 'romer.Rdata' file, which will introduce a list
object with the name 'romerlst' into the working directory, so the first
argument should be rsltlst = romerlst.

Second, see the code for runRomer, specifically the line that creates the
'sets' object, which will show how to create the correct genesetlst object.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = ExpressionSet,fit = MArrayLM}: Output romer results using microarray data

\item \code{object = DGEList,fit = DGEGLM}: Output romer results using RNA-Seq data processed using edgeR

\item \code{object = EList,fit = MArrayLM}: Output romer results using RNA-Seq data processed using voom.
}}

\author{
James W. MacDonald <jmacdon@u.washington.edu>
}
