% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingTools.R
\name{makeGoGeneTable}
\alias{makeGoGeneTable}
\title{Make Gene table from GO analysis results}
\usage{
makeGoGeneTable(
  fit.table,
  probe.sum.table,
  go.id,
  cont.name,
  base.dir = NULL,
  extraname = NULL,
  probecol = "PROBEID",
  affy = TRUE
)
}
\arguments{
\item{fit.table}{The output from \link[limma]{topTable}}

\item{probe.sum.table}{The output from running \link[GOstats]{probeSetSummary} on a \link[GOstats:GOHyperGResult-class]{GOHyperGResults} object.}

\item{go.id}{The GO ID of interest}

\item{cont.name}{The contrast name.}

\item{base.dir}{Character. Where should the HTML tables be generated? Defaults to NULL.}

\item{extraname}{Character. An extra name that can be used if the contrast name isn't descriptive enough.}

\item{probecol}{The column name in the topTable object that contains probe IDs. Defaults to PROBEID.}

\item{affy}{Boolean. Are the arrays from Affymetrix?}
}
\value{
Returns an \link[ReportingTools:HTMLReportRef-class]{HTMLReportRef} object.
}
\description{
A function to create an HTML table showing genes that gave rise to a significant GO term
}
\details{
This is an internal function, not intended to be called by the end user. Documentation here for clarity.
After running a GO analysis, it is advantageous to output a table listing those
genes that gave rise to a significant GO term. This function creates the table, along with links to Netaffx
(if the data are Affymetrix) and to the NCBI Gene database (if there are Entrez Gene IDs).
}
\author{
Jim MacDonald
}
