% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbSeqRep.R
\docType{methods}
\name{+,AbSeqRep,AbSeqRep-method}
\alias{+,AbSeqRep,AbSeqRep-method}
\title{Combines 2 \linkS4class{AbSeqRep} objects together for comparison}
\usage{
\S4method{+}{AbSeqRep,AbSeqRep}(e1, e2)
}
\arguments{
\item{e1}{AbSeqRep object.}

\item{e2}{AbSeqRep object.}
}
\value{
\linkS4class{AbSeqCRep} object. Calling \code{abseqR}'s
functions on this object will always result in a comparison.
}
\description{
Combines 2 \linkS4class{AbSeqRep} objects together for comparison
}
\examples{
# Use example data from abseqR as abseqPy's output, substitute this
# with your own abseqPy output directory
abseqPyOutput <- tempdir()
file.copy(system.file("extdata", "ex", package = "abseqR"), abseqPyOutput, recursive=TRUE)
samples <- abseqReport(file.path(abseqPyOutput, "ex"), report = 0)

# The provided example data has PCR1, PCR2, and PCR3 samples contained within
# pcr1 and pcr2 are instances of AbSeqRep
pcr1 <- samples[["PCR1"]]
pcr2 <- samples[["PCR2"]]

# pcr12 is an instance of AbSeqCRep
pcr12 <- pcr1 + pcr2

# you can now call the report function on this object
# report(pcr12)           # uncomment this line to execute report
}
\seealso{
\code{\link{abseqReport}} returns a \code{list} of \code{AbSeqRep}s
}
