% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upstreamAnalysis.R
\name{.analyzeUpstreamValidity}
\alias{.analyzeUpstreamValidity}
\title{Plots the validity of upstream sequences}
\usage{
.analyzeUpstreamValidity(upstreamDirectories, upstreamOut, expectedLength,
  upstreamLengthRange, sampleNames, combinedNames, mashedNames,
  .save = TRUE)
}
\arguments{
\item{upstreamDirectories}{list type. List of sample directories}

\item{upstreamOut}{string type. Output directory}

\item{expectedLength}{int type. Expected length of upstream sequences.
(i.e. upstream_end - upstream_start + 1). If this is infinite, no plots
will be generated.}

\item{upstreamLengthRange}{string type. start_end format}

\item{sampleNames}{vector type. 1-1 with upstream directories}

\item{combinedNames}{string type. Title friendly "combined" sample names}

\item{mashedNames}{string type. File friendly "mashed-up" sample names}

\item{.save}{logical type. Save Rdata?}
}
\value{
None
}
\description{
Plots the distribution of valid, faulty, and missing start
codon in IGV germlines (repeated for gene and family levels).
}
