% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{tTest}
\alias{tTest}
\title{Use t Test to Compare Two Groups}
\usage{
tTest(object, groups, probe2gene = TRUE)
}
\arguments{
\item{object}{ExpressionSet object}

\item{groups}{string indicating the name of the variable of the phenoData
containing the group information}

\item{probe2gene}{logical; if \code{TRUE} Affymetrix probeset IDs are translated
into gene symbols; if \code{FALSE} no such translation is conducted}
}
\value{
Object of class \code{"tTest"}, a data frame with the following columns
\item{gSymbol}{Gene Symbol}
\item{p}{p-value of the difference between the groups}
\item{logRatio}{Log ratio of the expression between the groups}
\item{pBH}{p-value of the difference between the groups,
with Benjamini-Hochberg multiplicity correction}
\item{tStat}{Student t-statistic of the different between groups}
}
\description{
Use a (modified) t test to compare two groups
}
\details{
For multiple testing the \code{mt.rawp2adjp} function of package
\code{multtest} is used.
}
\examples{
if (require(ALL)){
  data(ALL, package = "ALL")
  ALL <- addGeneInfo(ALL)
  ALL$BTtype <- as.factor(substr(ALL$BT,0,1))
  tTestRes <- tTest(object = ALL,	groups = "BTtype", probe2gene = TRUE)
  volcanoPlot(tTestRes)  
}
}
\seealso{
\code{rowttests} in \code{\link[genefilter]{rowFtests}}
}
\author{
Willem Talloen, Tobias Verbeke
}
\keyword{htest}
