% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe2gene.R
\name{probe2gene}
\alias{probe2gene}
\title{Translate Affymetrix probeset IDs into gene symbols}
\usage{
probe2gene(probesetIds, chipPkg)
}
\arguments{
\item{probesetIds}{Affymetrix probeset IDs}

\item{chipPkg}{string indicating the annotation package for the chip}
}
\value{
Vector containing the respective gene symbols
}
\description{
Auxiliary function for (currently) spectralMap
allowing the conversion of Affy probeset IDs to gene symbols
}
\examples{
if (require(ALL)){
	data(ALL, package = "ALL")
	chip <- annotation(ALL)
	chipAnnotationPkg <- paste(chip, "db", sep = ".")
	res <- probe2gene(featureNames(ALL), chipAnnotationPkg)
	head(res)
}
}
\seealso{
\code{\link{spectralMap}}, \code{\link[a4Classif]{lassoClass}}, ...
}
\author{
Tobias Verbeke
}
\keyword{manip}
