% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profilePlot.R
\name{plotCombination2genes}
\alias{plotCombination2genes}
\title{Plot a Combination of Two Genes}
\usage{
plotCombination2genes(
  probesetId1 = NULL,
  probesetId2 = NULL,
  geneSymbol1 = NULL,
  geneSymbol2 = NULL,
  object,
  groups,
  addLegend = TRUE,
  legendPos = "topleft",
  probe2gene = TRUE,
  colvec = NULL,
  ...
)
}
\arguments{
\item{probesetId1}{First probeset id, plotted in the x-axis}

\item{probesetId2}{Second probeset id, plotted in the y-axis}

\item{geneSymbol1}{First gene symbol, plotted in the x-axis}

\item{geneSymbol2}{Second gene symbol, plotted in the y-axi}

\item{object}{ExpressionSet object for the experiment}

\item{groups}{string containing the name of the grouping variable}

\item{addLegend}{Logical value to indicate whether a legend needs to be draw}

\item{legendPos}{Position on the graph where to put the legend}

\item{probe2gene}{should the probeset be translated to a gene symbol
(used for the default title of the plot}

\item{colvec}{a character vector of colors. If not specified it will be 
automatically generated by \code{a4palette}}

\item{...}{This allows to specify typical arguments in the \code{plot} functio}
}
\value{
If a gene id is given, the plots for only the first probeset is displayed 
  and a character vector of corresponding probeset IDs is returned invisibly.  
  It is a list containing
  \item{probeset1 }{Probeset ids measuring 'gene1'}
  \item{probeset1 }{Probeset ids measuring 'gene1'}
  If a probeset id is given, one single profile plot for the probeset is 
 displayed.
}
\description{
Plot a Combination of Two Genes
}
\examples{
if (require(ALL)){
 data(ALL, package = "ALL")
 ALL <- addGeneInfo(ALL)
 aa <- plotCombination2genes(geneSymbol1 = 'HLA-DPB1', geneSymbol2 = 'CD3D',
		object = ALL, groups = "BT",
		addLegend = TRUE, legendPos = 'topright')
 aa
}
}
\seealso{
\code{\link{plot1gene}}
}
\author{
W. Talloen, T. Verbeke
}
