% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{logLikelihood}
\alias{logLikelihood}
\title{Compute a loglikelihood ratio test}
\usage{
logLikelihood(
  in_1,
  in_2,
  df_1 = NULL,
  df_2 = NULL,
  in_pdf = NULL,
  verbose = FALSE
)
}
\arguments{
\item{in_1}{Residuals of model 1 of the input data.}

\item{in_2}{Residuals of model 2 of the input data.}

\item{df_1}{Degrees of freedom of the input model 1. If either \code{df_1} or
\code{df_2} is NULL, the difference between the degrees of freedom of the
two models is assumed to be 1.}

\item{df_2}{Degrees of freedom of the input model 2. If either \code{df_1} or
\code{df_2} is NULL, the difference between the degrees of freedom of the
two models is assumed to be 1.}

\item{in_pdf}{Probability distribution function, passed on to
\link{computeLogLik}, if NULL a normal distribution is used.}

\item{verbose}{Verbose if \code{in_verbose=1}}
}
\value{
A list with entries \itemize{ \item \code{statistic}: The test
statistic \item \code{delta_df}: The difference in degrees of freedom between
input model 1 and 2 \item \code{p.value}: p value of the statistical test. }
}
\description{
Compute a likelihood ratio test based on the loglikelihoods of the residuals
of two different models of the same data.
}
\examples{
 library(BSgenome.Hsapiens.UCSC.hg19)
 data(lymphoma_test)
 data(sigs)
 data(cutoffs)
 word_length <- 3
 temp_list <- create_mutation_catalogue_from_df(
   lymphoma_test_df,this_seqnames.field = "CHROM",
   this_start.field = "POS",this_end.field = "POS",
   this_PID.field = "PID",this_subgroup.field = "SUBGROUP",
   this_refGenome = BSgenome.Hsapiens.UCSC.hg19,
   this_wordLength = word_length)
 lymphoma_catalogue_df <- temp_list$matrix
 lymphoma_PIDs <- colnames(lymphoma_catalogue_df)
 current_sig_df <- AlexCosmicValid_sig_df
 current_sigInd_df <- AlexCosmicValid_sigInd_df
 current_cutoff_vector <- cutoffCosmicValid_rel_df[6, ]
 iniLCDList <- LCD_complex_cutoff(
   in_mutation_catalogue_df = lymphoma_catalogue_df[, 1, drop = FALSE],
   in_signatures_df = current_sig_df,
   in_cutoff_vector = current_cutoff_vector,
   in_method = "relative", in_rescale = TRUE,
   in_sig_ind_df = current_sigInd_df)
 current_sig_df <- AlexCosmicValid_sig_df[, -9]
 current_sigInd_df <- AlexCosmicValid_sigInd_df[-9,]
 current_cutoff_vector <- cutoffCosmicValid_rel_df[6, -9]
 redLCDList <- LCD_complex_cutoff(
   in_mutation_catalogue_df = lymphoma_catalogue_df[, 1, drop = FALSE],
   in_signatures_df = current_sig_df,
   in_cutoff_vector = current_cutoff_vector,
   in_method = "relative", in_rescale = TRUE,
   in_sig_ind_df = current_sigInd_df)
 logLikelihood(iniLCDList, redLCDList)
 
}
