% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{cosineMatchDist}
\alias{cosineMatchDist}
\title{Compute an altered cosine distance of two vectors}
\usage{
cosineMatchDist(a, b)
}
\arguments{
\item{a, b}{Numerical vectors of same length}
}
\value{
The scalar product of the reduced input vectors divided by the
       product of the norms of the two reduced input vectors
}
\description{
This is an altered cosine distance: it first reduced the dimension of the
two input vectors to only those coordinates where both have non-zero entries.
The cosine similarity is then computed on these reduced vectors, i.e. on a
sub-vector space.
}
\examples{
## 1. Orthogonal vectors:
cosineMatchDist(c(1,0),c(0,1))
## 2. Non-orthogonal vectors:
cosineMatchDist(c(1,0),c(1,1))

}
