% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indel_functions.R
\name{confidence_indel_calulation}
\alias{confidence_indel_calulation}
\title{Wrapper to compute confidence intervals for SNV and INDEL signatures of a
cohort or single-sample}
\usage{
confidence_indel_calulation(in_current_indel_df, in_current_snv_df)
}
\arguments{
\item{in_current_indel_df}{A INDEL mutational catalog. Mutational catalog can
be constucted with
\code{\link[YAPSA]{create_indel_mutation_catalogue_from_df}}}

\item{in_current_snv_df}{A SNV mutational catalog. Mutational catalog can be
constuced with \code{\link[YAPSA]{create_mutation_catalogue_from_df}}}
}
\value{
A list is returned containing 12 objects. For each cutoff data frame
  two corrosponding object are present. First, the \code{p} gtable object
  which can be used for gaphically visualization, and second a dataframe
  containing  the corrosponding upper and lower bounds of the confidence
  intervals.
}
\description{
Wrapper function around \code{\link[YAPSA]{confIntExp}}, which is applies to
every signature or sample pair in a cohort. The extracted lower bound of the
confidence intervals are added to the input data which is reodered and melted
in order to prepare for visualization with ggplot2. The calculates of
confidence intervals is based on a profiling likelihood algorithm and the
wrapper calculates the data for the exposure contubution identefied with SNV
and INDEL signature decompositions and application of the following cutoffs:
\enumerate{ \item \code{CosmicValid_absCutoffVector} \item
\code{CosmicValid_normCutoffVector} \item \code{CosmicArtif_absCutoffVector}
\item \code{CosmicArtif_normCutoffVector} \item
\code{PCAWGValidSNV_absCutoffVector} \item
\code{PCAWGValidID_absCutoffVector} } The function makes use of differnet
YAPSA functions. For each of the above stated cutoff vectors a per PID
decompostion of the SNV and INDEL catalog is calulated respectivly using
\code{\link[YAPSA]{LCD_complex_cutoff_perPID}}. In a next step,
\code{\link[YAPSA]{variateExp}} wich is a wrapper around
\code{\link[YAPSA]{confIntExp}} to compute confidence intervals for a cohort
is used. A dataframe is returend with the upper and lower bounds of the
confidence intervals. In a last step
\code{\link[YAPSA]{plotExposuresConfidence_indel}} to plot the exposures to
extracted signatures including confidence intervals computed with e.g. by
\code{\link[YAPSA]{variateExp}}.
}
\examples{
data("GenomeOfNl_MutCat")

}
